<?php

namespace Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator;

use Drupal\Core\Routing\RouteProviderInterface;

/**
 * Class SitemapWriter
 * @package Drupal\simple_sitemap\Plugin\simple_sitemap\SitemapGenerator
 */
class SitemapWriter extends \XMLWriter {

  const GENERATED_BY = 'Generated by the Simple XML Sitemap Drupal module: https://drupal.org/project/simple_sitemap.';
  const XML_VERSION = '1.0';
  const ENCODING = 'UTF-8';

  /**
   * @var \Drupal\Core\Routing\RouteProvider
   */
  protected $routeProvider;

  public function __construct(RouteProviderInterface $route_provider) {
    $this->routeProvider = $route_provider;
  }

  /**
   * Adds the XML stylesheet to the XML page.
   */
  public function writeXsl() {
    // Using this instead of URL::fromRoute() to avoid creating a path with the
    // subdomain from which creation was triggered which might lead to a CORS
    // problem. See https://www.drupal.org/project/simple_sitemap/issues/3131672.
    $xsl_url = $this->routeProvider
      ->getRouteByName('simple_sitemap.sitemap_xsl')
      ->getPath();

    // The above workaround however generates an incorrect path when the site is
    // located in a subdirectory, which is why the following logic adds the base
    // path of the installation.
    // See https://www.drupal.org/project/simple_sitemap/issues/3154494.
    // All of this seems to be an over engineered way of writing 'sitemap.xsl',
    // but may be useful in cases where another module alters the routes.
    $xsl_url = base_path() . ltrim($xsl_url, '/');

    $this->writePI('xml-stylesheet', 'type="text/xsl" href="' . $xsl_url . '"');
  }

  public function writeGeneratedBy() {
    $this->writeComment(self::GENERATED_BY);
  }

  public function startSitemapDocument() {
    $this->startDocument(self::XML_VERSION, self::ENCODING);
  }

}
